#include "write_graph.h"

write_graph::write_graph()
{
	max_x = 0;
	max_y = 0;
	max_z = 0;
	min_x = 8192.0;
	min_y = 8192.0;
	min_z = 8192.0;
}

write_graph::~write_graph()
{
	
}

void write_graph::mywrite(int log, char *buf)
{
	_write (log, buf, strlen (buf));
}


void write_graph::kills_per_time(demodata_t* pos, resultdata* result)
{
	int* rgb;
	int kills[1025];
	bool alive[1025];
	int last_kill[1025];
	for (int i = 0; i < 1024; i++) {
		kills[i] = 0;
		alive[i] = false;
		last_kill[i] = -1;
	}
	int max_kills = result->get_max_player_total_kills()+1;
	int total_time = result->get_total_time()+1;
	for (i = 10; i < max_kills; i+= 10) { // write y grid
		graph.draw_line_rel (
			0, (double) i / (double) max_kills,  
			1, (double) i / (double) max_kills, 
			255, 255, 255);
	}
	for (;;) {
		if (pos == 0) break;
		switch (pos->type) {
		case 1: 
			if ((pos->killer > -1) && (pos->victim > -1)) { 
				if (pos->victim != pos->killer) { // frag
					kills[pos->killer]++;
					if (last_kill[pos->killer] > -1) {
						rgb = get_rgb (pos->killer, result->get_player_count());
						result->get_player(pos->killer)->stats_color[0] = rgb[0];
						result->get_player(pos->killer)->stats_color[1] = rgb[1];
						result->get_player(pos->killer)->stats_color[2] = rgb[2];
						graph.draw_line_rel (
							(double) last_kill[pos->killer] / (double) total_time, 
							(double) (kills[pos->killer]-1) / (double) max_kills, 
							(double) pos->time / (double) total_time, 
							(double) kills[pos->killer] / (double) max_kills, 
							rgb[0], rgb[1], rgb[2]);
					}
					last_kill[pos->killer] = pos->time;
					alive[pos->victim] = false;
				}
			}
			break;
		case 5:
			char tempstr[260];
			strcpy (tempstr, pos->message);
			i = 0;
			while ((tempstr[i] != '\\') && (tempstr[i] != 0)) {
				i++;
			}
			tempstr[i] = 0;
			alive[result->get_player_number(tempstr)] = true;
		default: 
			break;
		}
		pos = pos->next;
	}
}

unsigned int write_graph::ksd_distribution(demodata_t* pos)
{
	unsigned int ksd_count = 0;
	int* rgb;
	char temp[1400];
	vec3_t playerpos[1025];
	int lastframe[1025];
	int mapcount = 0;
	while (pos != 0) {
		temp[0] = 0;
		switch (pos->type) {
		case 1: 
			if ((pos->killer > -1) && (pos->victim > -1)) { 
				if (pos->victim == pos->killer) { // suicide
					if (((playerpos[pos->killer][0] != 0) 
						|| (playerpos[pos->killer][1] != 0)
						|| (playerpos[pos->killer][2] != 0)) 
						&& (pos->frame <= lastframe[pos->killer]+50)) {
						graph.draw_circle_filled_rel (
							get_Q2_coord (playerpos[pos->killer][0], min_x, max_x), 
							get_Q2_coord (playerpos[pos->killer][1], min_y, max_y), 
							2, 0, 0, 255);
						ksd_count++;
					}
				} else { // frag
					if (((playerpos[pos->killer][0] != 0) 
						|| (playerpos[pos->killer][1] != 0)
						|| (playerpos[pos->killer][2] != 0)) 
						&& (pos->frame <= lastframe[pos->killer]+50)) {
						graph.draw_circle_filled_rel (
							get_Q2_coord (playerpos[pos->killer][0], min_x, max_x), 
							get_Q2_coord (playerpos[pos->killer][1], min_y, max_y), 
							2, 0, 255, 0);
						ksd_count++;
					}
					if (((playerpos[pos->victim][0] != 0) 
						|| (playerpos[pos->victim][1] != 0)
						|| (playerpos[pos->victim][2] != 0))
						&& (pos->frame < lastframe[pos->victim]+50)) {
						graph.draw_circle_filled_rel (
							get_Q2_coord (playerpos[pos->victim][0], min_x, max_x), 
							get_Q2_coord (playerpos[pos->victim][1], min_y, max_y), 
							2, 255, 0, 0);
						ksd_count++;
					}
				}
			} else if ((pos->killer == -1) && (pos->victim > -1)) { // death
				if (((playerpos[pos->victim][0] != 0) 
					|| (playerpos[pos->victim][1] != 0)
					|| (playerpos[pos->victim][2] != 0)) 
					&& (pos->frame <= lastframe[pos->victim]+100)) {
					graph.draw_circle_filled_rel (
						get_Q2_coord (playerpos[pos->victim][0], min_x, max_x),
						get_Q2_coord (playerpos[pos->victim][1], min_y, max_y), 
						2, 255, 255, 255);
					ksd_count++;
				}
			}
			break;
		case 4:
			mapcount++;
			if (mapcount > 1) {
				return ksd_count;
			}
			break;
		case 111: // origin
			if (pos->killer > -1) {
				playerpos[pos->killer][0] = pos->vp_float[0];
				playerpos[pos->killer][1] = pos->vp_float[1];
				playerpos[pos->killer][2] = pos->vp_float[2];
				lastframe[pos->killer] = pos->frame;
			}
			break;
		default: // miscellaneous messages
			break;
		}
		pos = pos->next;
	}
	return ksd_count;
}

unsigned int write_graph::player_ways(demodata_t* pos, int* color_low, int* color_high)
{
	unsigned int coord_count = 0;
	const int graph_size_x = 640;
	const int graph_size_y = 480;
	int mapcount = 0;
	int r_diff = color_high[0] - color_low[0];
	int g_diff = color_high[1] - color_low[1];
	int b_diff = color_high[2] - color_low[2];
	while (pos != 0) {
		double gamma;
		switch (pos->type) {
		case 4:
			mapcount++;
			if (mapcount > 1) {
				return coord_count;
			}
			break;
		case 111: // origin	
			if (pos->vp_float[2] > 4096.0) {
				gamma = (pos->vp_float[2] - min_z) / (8192.0-min_z + max_z);
			} else {
				gamma = (pos->vp_float[2] + (8192.0-min_z)) / (8192.0-min_z + max_z);
			}
			graph.draw_pixel_rel (
				get_Q2_coord(pos->vp_float[0], min_x, max_x), 
				get_Q2_coord(pos->vp_float[1], min_y, max_y), 
				color_low[0] + gamma * r_diff,
				color_low[1] + gamma * g_diff,
				color_low[2] + gamma * b_diff);
			coord_count++;
			break;
		default: // miscellaneous messages
			break;
		}
		pos = pos->next;
	}
	return coord_count;
}

void write_graph::calculate_max_values(demodata_t* pos)
{
	if (pos->type == 4) {
		pos = pos->next;
	}
	while ((pos != 0) && (pos->type != 4)) {
		switch (pos->type) {
		case 111:
			if ((pos->vp_float[0] > max_x) && (pos->vp_float[0] < 4096.0)) {
				max_x = pos->vp_float[0];
			}
			if ((pos->vp_float[1] > max_y) && (pos->vp_float[1] < 4096.0)) {
				max_y = pos->vp_float[1];
			}
			if ((pos->vp_float[2] > max_z) && (pos->vp_float[2] < 4096.0)) {
				max_z = pos->vp_float[2];
			}
			if ((pos->vp_float[0] < min_x) && (pos->vp_float[0] > 4096.0)) {
				min_x = pos->vp_float[0];
			}
			if ((pos->vp_float[1] < min_y) && (pos->vp_float[1] > 4096.0)) {
				min_y = pos->vp_float[1];
			}
			if ((pos->vp_float[2] < min_z) && (pos->vp_float[2] > 4096.0)) {
				min_z = pos->vp_float[2];
			}
			break;
		default:
			break;
		}
		pos = pos->next;
	}
	int dx = max_x + (8192.0-min_x);
	int dy = max_y + (8192.0-min_y);
//	int dz = max_z + (8192.0-min_z);
	if (dx > dy) {
		scale = 8192.0 / dx * 0.95; // scale to 95 percent of image size
	} else {
		scale = 8192.0 / dy * 0.95; // scale to 95 percent of image size
	}
}

int* write_graph::get_rgb(int part, int whole)
{
	double ratio = (double) part / (double) whole;
	static int rgb[3];
	rgb[0] = (int) (ratio * 255);
	rgb[1] = (int) (ratio * 255) % 8 * 32;
	rgb[2] = (int) (255 - ratio * 255) % 32 * 8;
	return rgb;
}

double write_graph::get_Q2_coord(double Q2_coord, double min, double max)
{
	double x = Q2_coord;
	if (x > 4096.0) {
		x -= 8192.0;
	}
	x += ((8192.0-min) - max) / 2.0; // centered
	x *= scale;
	x /= 8192.0;
	x += 0.5;
	if (x > 1) {
		x = 1;
	} else if (x < 0) {
		x = 0;
	}
	return x;
}

void write_graph::build(int x_size, int y_size)
{
	graph.build_graph (x_size, y_size); 
}

void write_graph::write(char *pathstr)
{
	graph.write_graph (pathstr);
}
